// ToolForm.cpp
//
// This file implements a Form-derived window that is the
// user interface for the simple Tool plug-in that this
// project creates. The Form contains two buttons. One button
// disables all LA modules in the system. The other enables
// all LA modules.
/////////////////////////////////////////////////////////////
#include "StdAfx.h"

#using <system.windows.forms.dll>
#using <system.drawing.dll>
#using <system.dll>
#using "TlaNetInterfaces.dll"


#include "ToolForm.h"

using namespace CPPSamplePlugIn;
using namespace System;
using namespace System::Collections;
using namespace Tektronix::LogicAnalyzer::TpiNet;
using namespace Tektronix::LogicAnalyzer::Common;

// ToolForm constructor
ToolForm::ToolForm(ITlaPlugInSupport* support) : m_components(0)
{
	m_plugInSupport = support;
	InitializeComponent();
}

// InitializeComponent()
//
// This method initializes the size and position of controls 
// on the surface of the Form.
void ToolForm::InitializeComponent()
{
	m_enableLAsButton = new System::Windows::Forms::Button();
    m_disableLAsButton = new System::Windows::Forms::Button();
    SuspendLayout();
    // 
    // EnableLAsButton
    // 
	m_enableLAsButton->Location = System::Drawing::Point(56, 104);
    m_enableLAsButton->Size = System::Drawing::Size(224, 40);
    m_enableLAsButton->TabIndex = 0;
    m_enableLAsButton->Text = S"Enable All LA Modules";
	m_enableLAsButton->add_Click(new EventHandler(this, &ToolForm::EnableLAsButton_Click));
    // 
    // DisableLAsButton
    // 
	m_disableLAsButton->Location = System::Drawing::Point(56, 32);
	m_disableLAsButton->Size = System::Drawing::Size(224, 40);
    m_disableLAsButton->TabIndex = 1;
    m_disableLAsButton->Text = S"Disable All LA Modules";
	m_disableLAsButton->add_Click(new EventHandler(this, ToolForm::DisableLAsButton_Click));
    // 
    // ToolForm
    // 
	AutoScaleBaseSize = System::Drawing::Size(6, 15);
	ClientSize = System::Drawing::Size(336, 176);
	Controls->Add(m_disableLAsButton);
    Controls->Add(m_enableLAsButton);
    Text = S"Example Tool Plug-In";
    ResumeLayout(false);

	// This code works only if the file "ToolIcon.Ico" is 
	// placed int the same dire
	System::Drawing::Icon* prevIcon = this->Icon;
    try {
        this->Icon = new System::Drawing::Icon(S"ToolIcon.ico");
    }
    catch (Exception*) { 
        this->Icon = prevIcon;
    }
}

// Dispose()
//
// Method used to dispose the ToolForm. The plug-in calls this
// method when it is itself disposed.
void ToolForm::Dispose( bool disposing )
{
	if( disposing )
	{
		if(m_components)
		{
			m_components->Dispose();
		}
	}
	__super::Dispose( disposing );
}


// DisableLAsButton_Click()
//
// Disables all LA modules in the system in response to
// user pressing the m_disableLAsButton button.
void ToolForm::DisableLAsButton_Click(Object*, EventArgs*) 
{
    SetLAsEnabledState(false);
}


// EnableLAsButton_Click()
//
// Enables all LA modules in the system in response to
// user pressing the m_enableLAsButton button.
void ToolForm::EnableLAsButton_Click(Object*, EventArgs*) 
{
    SetLAsEnabledState(true);
}


// SetLAsEnabledState()
//
// This utility method uses the cached ITlaPlugInSupport object
// to find all LA modules and set their enabled state.
void ToolForm::SetLAsEnabledState (bool enabledState) {
	if (m_plugInSupport) {
		
		// The ITlaSystem::DataSources property contains a list
		// of all data sources in the system
		ArrayList* dataSources = m_plugInSupport->System->DataSources;
		
		// Search through the list for ILAModule instances
		// and changed their enabled state.
		for (int index = 0; index < dataSources->Count; ++index) {
			ILAModule* laModule = dynamic_cast<ILAModule*>
				(dataSources->Item[index]);
			IModuleRunStatus* module = dynamic_cast<IModuleRunStatus*>
				(dataSources->Item[index]);
			if (laModule && module) {
				module->IsEnabled = enabledState;
			}
		}
	}
}
